/* ==================================================================
   Copyright:   Travellers Tales (UK)
   File:        MemoryManager.inl
   Author:      Andrew Davies
   Date:		27th May 2008
   Format:      Generic C++
   Description: (Possibly) inline Memory manager functions

===================================================================== */


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

inline void MemoryManager::Defrag( )
{
	// Sort all the pools the MUST be done before calling defrag
	for(int i=0; i<NUMPOOLS; i++)
	{
		while(m_PoolSorted[i]==FALSE)
		{
			LockMgr(MEM_FILE());
			SortPool(i);
			UnlockMgr();
// 			#if !defined(_WII_TARGET)
// 			NuThreadSleep(0);
// 			#endif
		}
	}

	// Defrag the pools
	LockMgr(MEM_FILE());
	DefragPools();
	UnlockMgr();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// Allocate a string from the pool buffer. This memory CAN be freed using freepool() (or FreeStringPool).
/// 
/// \return				Address of new string
/// \param	String		Address of string which will be duplicated
/// 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

inline char* MemoryManager::_DO_NOT_USE__CALL_ALLOCSTRINGPOOL_MACRO_INSTEAD( const char *String, int Alignment, char* file)
{
	if (!String)
		return NULL;

	const size_t size = NuStrLen(String)+1;
	char *copy = (char*)_DO_NOT_USE__CALL_ALLOCPOOL_MACRO_INSTEAD(MEMMAN_ALLOC_SIZE(size), Alignment, file);

	if (copy)
		NuStrCpy(copy,String);

	return copy;
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// Free string to memory pools
/// 
/// \return 			None
/// \param	String		Address of string to free
/// 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

inline void MemoryManager::FreeStringPool( char *String, bool DirectFree )
{
	if(!String)
		return;

	const size_t Size = NuStrLen(String)+1;
	FreePool((void*) String, MEMMAN_ALLOC_SIZE(Size), DirectFree);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
inline void MemoryManager::memFreeList::Append(memFreeHeader* prev, memFreeHeader* link)
{
	if(prev)
	{
		link->next = prev->next;
		prev->next = link;
	}
	else
	{
		link->next = head;
		head = link;
	}
	count++;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
inline void MemoryManager::memFreeList::Unlink(memFreeHeader* prev, memFreeHeader* link)
{
	if(prev)
	{
		NuAssert(prev->next==link,"prev->next is not link");
		prev->next = link->next;
	}
	else
	{
		NuAssert(head==link,"head is not link");
		head = link->next;
	}
	count--;
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
/// Remove memory manager debugging methods
///
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#if defined(_MEMORY_MANAGER_DEBUG)

inline int MemoryManager::HeaderSize(void) const
{
	if( m_TrackMemory )
		return (signed)sizeof( memAllocHeader );
	else
		return 0;
}

inline int MemoryManager::Overrun(void) const
{
	if( m_TrackMemory )
		return MEMMAN_OVERRUNBUFFERSIZE;
	else
		return 0;
}

#else // defined(_MEMORY_MANAGER_DEBUG)

inline void* MemoryManager::AddHeader(void* Mem, size_t Size, const char* fileClass)			{ return Mem; }
inline void* MemoryManager::RemoveHeader(void *Mem, size_t Size)								{ return Mem; }
inline void MemoryManager::VerifyMemory(void* mem, int memSize, void* hdr, int hdrSize)			{}
inline void	MemoryManager::VerifyPool(void* mem, int memSize)									{}
inline void	MemoryManager::VerifyPool()															{}
inline void	MemoryManager::VerifyFree()															{}
inline void	MemoryManager::VerifyFree(void* mem, int memSize)									{}
inline void	MemoryManager::VerifyAlloc(void)													{}
inline void	MemoryManager::VerifyBlocks(void)													{}
inline void	MemoryManager::Halt(MemoryError error, const char *pcReason)						{}
inline int MemoryManager::Overrun(void) const													{ return 0; }
inline int MemoryManager::HeaderSize(void) const												{ return 0; }
inline void	MemoryManager::SetBounds( memAllocHeader* memHeader )								{}
inline void	MemoryManager::CheckBounds( memAllocHeader* memHeader )								{}
inline void* MemoryManager::FindNextChunk(void* mem, int &size, int &type)						{ return NULL; }
inline int MemoryManager::GetLargestFreeChunk()													{ return 0; }

#endif // defined(_MEMORY_MANAGER_DEBUG)
